%%This script creates figure for the PRF Paper

clear all;clc;
load('/Users/luiblaes/Documents/Data PRF/Disk94.mat')
load('/Users/luiblaes/Documents/Data PRF/Disk45.mat')
load('/Users/luiblaes/Documents/Data PRF/Disk13.mat')
load('/Users/luiblaes/Documents/Data PRF/Disk14.mat')
load('/Users/luiblaes/Documents/Data PRF/Pent6.mat')
load('/Users/luiblaes/Documents/Data PRF/Sq92.mat')

fps=61.9; %Frames per second
fip=0;
LK=[];
LR=[];
fipc=[0];

S_A=21; %mm Is the sqrt(A_p)
Fnt=20;


%Figure 4a) Planar zig-zag of Disk

figure
handaxes1 = axes('Position', [0.12 0.12 0.8 0.8]);

plot3((PosXDisk13(1,1:TrajLDisk13)-PosXDisk13(1,1))/S_A,(PosYDisk13(1,1:TrajLDisk13)-PosYDisk13(1,1))/S_A,(PosZDisk13(1,1:TrajLDisk13)-PosZDisk13(1,1))/S_A,'b:','LineWidth',2)
view(-45,40)
hold on;
set(gca,'XTick',[-1.48 -1 -0.5 0]);
set(gca, 'FontSize', Fnt)
set(gca,'XTickLabel',str2mat('-1.5', '-1', '-0.5','  0'))
set(gca,'YTick',[-0.5 0 0.5]);
set(gca,'YTickLabel',str2mat('-0.5','0', '0.5'))
xlabel('$X/\sqrt{A_p}$','Interpreter','LaTex','FontSize', Fnt)
ylabel('$Y/\sqrt{A_p}$','Interpreter','LaTex','FontSize', Fnt)
zlabel('$Z/\sqrt{A_p}$','Interpreter','LaTex','FontSize', Fnt)
axis equal


%Obtain the points of zero Acceleration
[pks,locsr] = findpeaks(VelZDisk13(1,1:TrajLDisk13-1));
[pks,locsk] = findpeaks(-VelZDisk13(1,1:TrajLDisk13-1));

%Clean the points to interesting intervals
if locsr(1)>locsk(1)
    locsk=locsk(2:end);
else
end

if locsr(end)>locsk(end)
    locsr=locsr(1:end-1);
else
end

fip=0;
LK=[];
LR=[];
Tm=[];
for fi=1:length(locsk)
    if  locsk(fi)-locsr(fi)>10 && locsk(fi)>0 && locsr(fi)>0
        fip=fip+1;
        LK(fip)=locsk(fi);
        LR(fip)=locsr(fi);
    else
    end
end

%Just for figure
for fi=1:length(LK)
    
    plot3((PosXDisk13(1,LK(fi))-PosXDisk13(1,1))/S_A,(PosYDisk13(1,LK(fi))-PosYDisk13(1,1))/S_A,(PosZDisk13(1,LK(fi))-PosZDisk13(1,1))/S_A, 'ko','MarkerFaceColor','k')
    hold on
    plot3((PosXDisk13(1,LR(fi))-PosXDisk13(1,1))/S_A,(PosYDisk13(1,LR(fi))-PosYDisk13(1,1))/S_A,(PosZDisk13(1,LR(fi))-PosZDisk13(1,1))/S_A,'ko','MarkerFaceColor',[1 1 1])
end
set(handaxes1, 'Box', 'off')

hold off
handaxes3 = axes('Position', [0.7 0.4 0.2 0.2]);
plot((PosXDisk13(1,1:TrajLDisk13)-PosXDisk13(1,1))/S_A,(PosYDisk13(1,1:TrajLDisk13)-PosYDisk13(1,1))/S_A,'b:','LineWidth',2)

set(gca,'XTick',[-1.48 -1 -0.5 0]);
set(gca, 'FontSize', Fnt)
set(gca,'XTickLabel',str2mat('-1.5', '-1', '-0.5','  0'))
set(gca,'YTick',[-0.5 0 0.5]);
set(gca,'YTickLabel',str2mat('-0.5','0', '0.5'))

xlabel('$X/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
ylabel('$Y/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
axis equal
set(handaxes3, 'Box','off')


%Figure 4b)

figure
handaxes1 = axes('Position', [0.12 0.12 0.8 0.8]);

plot3((PosXDisk94(1,1:TrajLDisk94)-PosXDisk94(1,1))/S_A,(PosYDisk94(1,1:TrajLDisk94)-PosYDisk94(1,1))/S_A,(PosZDisk94(1,1:TrajLDisk94)-PosZDisk94(1,1))/S_A,'b:','LineWidth',2)
view(-45,40)
hold on;
set(gca,'XTick',[-0.5 0 0.5 1]);
set(gca, 'FontSize', Fnt)
set(gca,'XTickLabel',str2mat('-0.5', '  0', ' 0.5','   1'))
set(gca,'YTick',[0 0.5 1 1.5]);
set(gca,'YTickLabel',str2mat('  0','0.5', '  1', '1.5'))

xlabel('$X/\sqrt{A_p}$','Interpreter','LaTex','FontSize', Fnt)
ylabel('$Y/\sqrt{A_p}$','Interpreter','LaTex','FontSize', Fnt)
zlabel('$Z/\sqrt{A_p}$','Interpreter','LaTex','FontSize', Fnt)
axis equal
axis([-0.5 1 0 1.5])

[pks,locsr] = findpeaks(VelZDisk94(1,1:TrajLDisk94-1));
[pks,locsk] = findpeaks(-VelZDisk94(1,1:TrajLDisk94-1));

if locsr(1)>locsk(1)
    locsk=locsk(2:end);
else
end

if locsr(end)>locsk(end)
    locsr=locsr(1:end-1);
else
end

fip=0;
LK=[];
LR=[];
for fi=1:length(locsk)
    if  locsk(fi)-locsr(fi)>10 && locsk(fi)>0 && locsr(fi)>0
        fip=fip+1;
        LK(fip)=locsk(fi);
        LR(fip)=locsr(fi);
    else
    end
end

for fi=1:length(LK)
    plot3((PosXDisk94(1,LK(fi))-PosXDisk94(1,1))/S_A,(PosYDisk94(1,LK(fi))-PosYDisk94(1,1))/S_A,(PosZDisk94(1,LK(fi))-PosZDisk94(1,1))/S_A, 'ko','MarkerFaceColor','k')
    hold on
    plot3((PosXDisk94(1,LR(fi))-PosXDisk94(1,1))/S_A,(PosYDisk94(1,LR(fi))-PosYDisk94(1,1))/S_A,(PosZDisk94(1,LR(fi))-PosZDisk94(1,1))/S_A,'ko','MarkerFaceColor',[1 1 1])
end
set(handaxes1, 'Box', 'off')

hold off
handaxes3 = axes('Position', [0.7 0.4 0.2 0.2]);
plot((PosXDisk94(1,1:TrajLDisk94)-PosXDisk94(1,1))/S_A,(PosYDisk94(1,1:TrajLDisk94)-PosYDisk94(1,1))/S_A,'b:','LineWidth',2)
set(gca,'XTick',[-0.5 0 0.5 1]);
set(gca, 'FontSize', Fnt)
set(gca,'XTickLabel',str2mat('-0.5', '  0', ' 0.5','   1'))
set(gca,'YTick',[0 0.5 1 1.5]);
set(gca,'YTickLabel',str2mat('  0','0.5', '  1', '1.5'))

xlabel('$X/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
ylabel('$Y/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
axis equal
axis([-0.5 1 0 1.5])
set(handaxes3, 'Box','off')


%Figure 5

figure
handaxes1 = axes('Position', [0.12 0.12 0.8 0.8]);

plot3((PosXDisk45(1,1:TrajLDisk45)-PosXDisk45(1,1))/S_A,(PosYDisk45(1,1:TrajLDisk45)-PosYDisk45(1,1))/S_A,(PosZDisk45(1,1:TrajLDisk45)-PosZDisk45(1,1))/S_A,'b:','LineWidth',2)
view(-45,40)
hold on;

set(gca,'XTick',[-0.5 0 0.5 1]);
set(gca, 'FontSize', Fnt)
set(gca,'XTickLabel',str2mat('-0.5', '  0', ' 0.5','   1'))
set(gca,'YTick',[-0.5 0 0.5 1]);
set(gca,'YTickLabel',str2mat('-0.5','  0','0.5', '  1'))

xlabel('$X/\sqrt{A_p}$','Interpreter','LaTex','FontSize', Fnt)
ylabel('$Y/\sqrt{A_p}$','Interpreter','LaTex','FontSize', Fnt)
zlabel('$Z/\sqrt{A_p}$','Interpreter','LaTex','FontSize', Fnt)
axis equal
%axis([-1 1 -0.2 0.2])
%Obtain the points of zero Acceleration
[pks,locsr] = findpeaks(VelZDisk45(1,1:TrajLDisk45-1));
[pks,locsk] = findpeaks(-VelZDisk45(1,1:TrajLDisk45-1));

%Clean the points to interesting intervals
if locsr(1)>locsk(1)
    locsk=locsk(2:end);
else
end

if locsr(end)>locsk(end)
    locsr=locsr(1:end-1);
else
end

fip=0;
LK=[];
LR=[];
for fi=1:length(locsk)
    if  locsk(fi)-locsr(fi)>10 && locsk(fi)>0 && locsr(fi)>0
        fip=fip+1;
        LK(fip)=locsk(fi);
        LR(fip)=locsr(fi);
    else
    end
end
for fi=1:length(LK)
    
    plot3((PosXDisk45(1,LK(fi))-PosXDisk45(1,1))/S_A,(PosYDisk45(1,LK(fi))-PosYDisk45(1,1))/S_A,(PosZDisk45(1,LK(fi))-PosZDisk45(1,1))/S_A, 'ko','MarkerFaceColor','k')
    hold on
    plot3((PosXDisk45(1,LR(fi))-PosXDisk45(1,1))/S_A,(PosYDisk45(1,LR(fi))-PosYDisk45(1,1))/S_A,(PosZDisk45(1,LR(fi))-PosZDisk45(1,1))/S_A,'ko','MarkerFaceColor',[1 1 1])
end
set(handaxes1, 'Box', 'off')

hold off
handaxes3 = axes('Position', [0.7 0.4 0.2 0.2]);
plot((PosXDisk45(1,1:TrajLDisk45)-PosXDisk45(1,1))/S_A,(PosYDisk45(1,1:TrajLDisk45)-PosYDisk45(1,1))/S_A,'b:','LineWidth',2)

set(gca,'XTick',[-0.5 0 0.5 1 1.5]);
set(gca, 'FontSize', Fnt)
set(gca,'XTickLabel',str2mat('-0.5', '  0', ' 0.5','  1', '1.5'))
set(gca,'YTick',[-0.5 0 0.5 1]);
set(gca,'YTickLabel',str2mat('-0.5','  0','0.5', '  1'))

xlabel('$X/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
ylabel('$Y/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
axis equal
%axis([-1 1 -0.2 0.2])
set(handaxes3, 'Box','off')



%Figure 6

fip=0;
LK=[];
LR=[];
fipc=[0];
figure;

plot((PosXDisk13(1,1:TrajLDisk13)-PosXDisk13(1,1))/S_A,(PosYDisk13(1,1:TrajLDisk13)-PosYDisk13(1,1))/S_A,'b:','LineWidth',2)
hold on

[pks,locsr] = findpeaks(VelZDisk13(1,1:TrajLDisk13-1));
[pks,locsk] = findpeaks(-VelZDisk13(1,1:TrajLDisk13-1));

if locsr(1)>locsk(1)
    locsk=locsk(2:end);
else
end

if locsr(end)>locsk(end)
    locsr=locsr(1:end-1);
else
end

fip=0;
LK=[];
LR=[];
for fi=1:length(locsk)
    if locsk(fi)-locsr(fi)>10 && locsk(fi)>0 && locsr(fi)>0
        fip=fip+1;
        LK(fip)=locsk(fi);
        LR(fip)=locsr(fi);
    else
    end
end

for gui=1:fip
    p3=[PosXDisk13(1,LK(gui))-PosXDisk13(1,1),PosYDisk13(1,LK(gui))-PosYDisk13(1,1)];
    p4=[PosXDisk13(1,LR(gui))-PosXDisk13(1,1),PosYDisk13(1,LR(gui))-PosYDisk13(1,1)];
    dp2=p4-p3;
    dp3=p3-p4;
    strin= strcat('S');
    
    
end

for fi=1:length(LK)-1
    aaux=length(LK(fi):LR(fi+1))/2;
    P1=[PosXDisk13(1,LK(fi))-PosXDisk13(1,1) PosYDisk13(1,LK(fi))-PosYDisk13(1,1) 0];
    P2=[PosXDisk13(1,LK(fi)+round(aaux))-PosXDisk13(1,1) PosYDisk13(1,LK(fi)+round(aaux))-PosYDisk13(1,1) 0];
    P3=[PosXDisk13(1,LR(fi+1))-PosXDisk13(1,1) PosYDisk13(1,LR(fi+1))-PosYDisk13(1,1) 0];
    [center,rad]=circlefit3d(P1,P2,P3);
    
    Vec1=P1-center;
    Vec2=P3-center;
end

plot((PosXDisk13(1,LK(fi))-PosXDisk13(1,1))/S_A,(PosYDisk13(1,LK(fi))-PosYDisk13(1,1))/S_A, 'ko','MarkerFaceColor','k')
plot((PosXDisk13(1,LR(fi+1))-PosXDisk13(1,1))/S_A, (PosYDisk13(1,LR(fi+1))-PosYDisk13(1,1))/S_A,'ko')


circle2(center(1)/S_A,center(2)/S_A,rad/S_A);

p1=[center(1),center(2)];
p2=[PosXDisk13(1,LK(fi)+round(aaux))-PosXDisk13(1,1),PosYDisk13(1,LK(fi)+round(aaux))-PosYDisk13(1,1)];
dp=p2-p1;


quiver(p1(1)/S_A,p1(2)/S_A,dp(1)/S_A,dp(2)/S_A,0,'k','MaxHeadSize',0.1)
h76 = text(p2(1)/S_A+0.1,15/S_A, 'R_g')
set(h76, 'rotation', -80)
set(h76, 'FontSize', Fnt)

p3=[PosXDisk13(1,LK(fi)-round(aaux))-PosXDisk13(1,1),PosYDisk13(1,LK(fi)-round(aaux))-PosYDisk13(1,1)];
p4=[PosXDisk13(1,LK(fi+1)-round(aaux))-PosXDisk13(1,1),PosYDisk13(1,LK(fi+1)-round(aaux))-PosYDisk13(1,1)];
dp2=p4-p3;
dp3=p3-p4;


quiver((p3(1)+1.5)/S_A,(p3(2)-5)/S_A,dp2(1)/S_A,dp2(2)/S_A,0,'k','MaxHeadSize',0.3)
quiver((p4(1)+1.5)/S_A,(p4(2)-5)/S_A,dp3(1)/S_A,dp3(2)/S_A,0,'k','MaxHeadSize',0.3)
h1 = text(((p3(1)+1.5+p4(1)+1.5)/2)/S_A,-3/S_A, 'a')
set(h1, 'rotation', 10)
set(h1, 'FontSize', Fnt)
plot([p3(1) p3(1)+1.5]/S_A, [p3(2) p3(2)-5]/S_A,'k:');
plot([p4(1) p4(1)+1.5]/S_A, [p4(2) p4(2)-5]/S_A,'k:');
xlabel('$X/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
ylabel('$Y/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
yt = get(gca, 'YTick');
set(gca, 'FontSize', Fnt)
axis([-2 1.5 -0.5 2])


%Figure 7 a)

centers=[0.05:0.1:1.25];
countsD=[194,58,25,6,8,4,3,0,1,0,0,0,0];
countsH=[109,86,39,33,14,9,4,2,0,0,0,1,3];
countsHp=[224,39,17,7,3,5,1,0,0,0,0,0,4];
countsP=[108,60,39,45,25,10,5,3,0,2,1,0,1];
countsS=[34,59,41,51,33,27,24,17,7,2,1,0,1];
figure;
xerf=0:0.01:1;
yerfD= (1/2)*(1+erf((xerf+0.06)/((0.22)*sqrt(2))));
plot(xerf,yerfD,'k:','LineWidth',2)
hold on;
plot(centers,cumsum(countsD)/sum(countsD),'ko','MarkerSize', 14)
yerfHp= (1/2)*(1+erf((xerf+0.1)/((0.22)*sqrt(2))));
plot(xerf,yerfHp,'k:','LineWidth',2)
plot(centers,cumsum(countsHp)/sum(countsHp),'k*','MarkerSize', 14)
yerfH= (1/2)*(1+erf((xerf-0.08)/((0.22)*sqrt(2))));
plot(xerf,yerfH,'k:','LineWidth',2)
plot(centers,cumsum(countsH)/sum(countsH),'kh','MarkerSize', 14)
yerfP= (1/2)*(1+erf((xerf-0.12)/((0.22)*sqrt(2))));
plot(xerf,yerfP,'k:','LineWidth',2)
plot(centers,cumsum(countsP)/sum(countsP),'kp','MarkerSize', 14)
yerfS= (1/2)*(1+erf((xerf-0.3)/((0.22)*sqrt(2))));
plot(xerf,yerfS,'k:','LineWidth',2)
plot([0.2 0.2],[0 1],'k-.','LineWidth',2)
plot([0.6 0.6],[0 1],'k-.','LineWidth',2)
text(0.08,0.05,'(1)','Interpreter','LaTex','FontSize',16);
text(0.38,0.05,'(2)','Interpreter','LaTex','FontSize',16);
text(0.78,0.05,'(3)','Interpreter','LaTex','FontSize',16);
p=patch([0 0.2 0.2 0],[0 0 1 1],[1 0.9 0.9])
set(p,'FaceAlpha',0.5)
p=patch([0.2 0.6 0.6 0.2],[0 0 1 1],[1 0.5 0.5])
set(p,'FaceAlpha',0.5)
p=patch([0.6 1 1 0.6],[0 0 1 1],[1 0 0])
set(p,'FaceAlpha',0.5)
plot(centers,cumsum(countsS)/sum(countsS),'ks','MarkerSize', 14)
axis([0 1 0 1])
xlabel('$a/R_g$','Interpreter','LaTex', 'FontSize', Fnt)
ylabel('$\Phi(a/R_g)$','Interpreter','LaTex', 'FontSize', Fnt)
xt = get(gca, 'XTick');
set(gca, 'FontSize', Fnt)


%Figure 7 b)

Fnt=18;
ft=figure;
Q=[1 0.93 0.91 0.86 0.79]; %Isoperimetric Quotient
mu=[-0.06,-0.1, 0.08, 0.12, 0.3]; %Peak to Peak descent velocity (V_max - V_min) [mm/s]
plot(mu(1),Q(1),'ko','MarkerSize',Fnt)
hold on
plot(mu(2),Q(2),'k*','MarkerSize',Fnt)
plot(mu(3),Q(3),'kh','MarkerSize',Fnt)
plot(mu(4),Q(4),'kp','MarkerSize',Fnt)
plot(mu(5),Q(5),'ks','MarkerSize',Fnt)
axis([-0.1 0.3 0.75 1])
ylabel('$Q$','Interpreter','LaTex','FontSize',Fnt)
xlabel('$\mu$','Interpreter','LaTex','FontSize',Fnt)
xt = get(gca, 'XTick');
set(gca, 'FontSize',Fnt)




Fnt=20; %Figure 8 a)

f5=figure
handaxes1 = axes('Position', [0.12 0.12 0.8 0.8]);

plot3((PosXDisk14-PosXDisk14(1))/S_A, (PosYDisk14-PosYDisk14(1))/S_A,(PosZDisk14(1,1:TrajLDisk14)-PosZDisk14(1,1))/S_A,'b:','LineWidth',2)
view(-45,40)
hold on;

set(gca,'XTick',[-1 0 1]);
set(gca, 'FontSize', Fnt)
set(gca,'XTickLabel',str2mat('-0.75', ' 0', '0.75'))
set(gca,'YTick',[-0.1 0.1]);
set(gca,'YTickLabel',str2mat('','0.1'))
xlabel('$X/\sqrt{A_p}$','Interpreter','LaTex','FontSize', Fnt)
ylabel('$Y/\sqrt{A_p}$','Interpreter','LaTex','FontSize', Fnt)
zlabel('$Z/\sqrt{A_p}$','Interpreter','LaTex','FontSize', Fnt)
axis equal
%axis([-1 1 -0.2 0.2])


%Obtain the points of zero Acceleration
[pks,locsr] = findpeaks(VelZDisk14(1,1:TrajLDisk14-1));
[pks,locsk] = findpeaks(-VelZDisk14(1,1:TrajLDisk14-1));

%Clean the points to interesting intervals
if locsr(1)>locsk(1)
    locsk=locsk(2:end);
else
end

if locsr(end)>locsk(end)
    locsr=locsr(1:end-1);
else
end

fip=0;
LK=[];
LR=[];
Tm=[];
for fi=1:length(locsk)
    if  locsk(fi)-locsr(fi)>10 && locsk(fi)>0 && locsr(fi)>0
        fip=fip+1;
        LK(fip)=locsk(fi);
        LR(fip)=locsr(fi);
        Tm(fip)=locsk(fi)-locsr(fi);
        Ang(fip)=sum(angle(locsr(fi):locsk(fi))); % Planar Angle turned at turning point
    else
    end
end

%Just for figure
for fi=1:length(LK)
    
    %The x-rotated is for disk 14 with plotPNAS run first
    plot3((PosXDisk14(LK(fi))-PosXDisk14(1))/S_A, (PosYDisk14(LK(fi))-PosYDisk14(1))/S_A,(PosZDisk14(1,LK(fi))-PosZDisk14(1,1))/S_A,'ko','MarkerFaceColor','k')
    hold on
    %The x-rotated is for disk 14 with plotPNAS run first
    plot3((PosXDisk14(LR(fi))-PosXDisk14(1))/S_A, (PosYDisk14(LR(fi))-PosYDisk14(1))/S_A,(PosZDisk14(1,LR(fi))-PosZDisk14(1,1))/S_A,'ko','MarkerFaceColor',[1 1 1])
end
set(handaxes1, 'Box', 'off')

hold off
handaxes3 = axes('Position', [0.7 0.4 0.2 0.2]);
plot((PosXDisk14-PosXDisk14(1))/S_A, (PosYDisk14-PosYDisk14(1))/S_A,'b:','LineWidth',2)

set(gca,'XTick',[-1 0 1]);
set(gca, 'FontSize', Fnt)
set(gca,'XTickLabel',str2mat('-0.75', ' 0', '0.75'))
set(gca,'YTick',[-0.1 0.1]);
set(gca,'YTickLabel',str2mat('','0.1'))


xlabel('$X/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
ylabel('$Y/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
axis equal
%axis([-1 1 -0.2 0.2])
set(handaxes3, 'Box','off')



%Figure 8 b)


Fnt=16;

f5=figure
handaxes1 = axes('Position', [0.12 0.12 0.8 0.8]);


plot3((PosXPent6(1,1:TrajLPent6)-PosXPent6(1,1))/S_A,(PosYPent6(1,1:TrajLPent6)-PosYPent6(1,1))/S_A,(PosZPent6(1,1:TrajLPent6)-PosZPent6(1,1))/S_A,'b:','LineWidth',2)
view(-40,45)
hold on;
set(gca,'XTick',[-0.5 0 0.5 1.2]);
set(gca, 'FontSize', Fnt)
set(gca,'XTickLabel',str2mat('-0.5', '  0', ' 0.5',' 1'))
set(gca,'YTick',[-1.5 -1 -0.5 0 0.5]);
set(gca,'YTickLabel',str2mat('-1.5','-1','-0.5', '0', '0.5'))
xlabel('$X/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
ylabel('$Y/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
zlabel('$Z/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
axis equal
axis([-0.75 1.2 -1.5 0.2])

%Obtain the points of zero Acceleration
[pks,locsr] = findpeaks(VelZPent6(1,1:TrajLPent6-1));
[pks,locsk] = findpeaks(-VelZPent6(1,1:TrajLPent6-1));

%Clean the points to interesting intervals
if locsr(1)>locsk(1)
    locsk=locsk(2:end);
else
end

if locsr(end)>locsk(end)
    locsr=locsr(1:end-1);
else
end

fip=0;
LK=[];
LR=[];
for fi=1:length(locsk)
    if  locsk(fi)-locsr(fi)>10 && locsk(fi)>0 && locsr(fi)>0
        fip=fip+1;
        LK(fip)=locsk(fi);
        LR(fip)=locsr(fi);
    else
    end
end

%Just for figure
for fi=1:length(LK)
    
    plot3((PosXPent6(1,LK(fi))-PosXPent6(1,1))/S_A,(PosYPent6(1,LK(fi))-PosYPent6(1,1))/S_A,(PosZPent6(1,LK(fi))-PosZPent6(1,1))/S_A, 'ko','MarkerFaceColor','k')
    hold on
    plot3((PosXPent6(1,LR(fi))-PosXPent6(1,1))/S_A,(PosYPent6(1,LR(fi))-PosYPent6(1,1))/S_A,(PosZPent6(1,LR(fi))-PosZPent6(1,1))/S_A,'ko','MarkerFaceColor',[1 1 1])
end

hold off
handaxes3 = axes('Position', [0.7 0.4 0.2 0.2]);
plot((PosXPent6(1,1:TrajLPent6)-PosXPent6(1,1))/S_A,(PosYPent6(1,1:TrajLPent6)-PosYPent6(1,1))/S_A,'b:','LineWidth',2)
set(gca,'XTick',[-0.5 0 0.5 1.2]);
set(gca, 'FontSize', Fnt)
set(gca,'XTickLabel',str2mat('-0.5', '  0', ' 0.5',' 1'))
set(gca,'YTick',[-1.5 -1 -0.5 0 0.5]);
set(gca,'YTickLabel',str2mat('-1.5','-1','-0.5', '0', '0.5'))
xlabel('$X/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
ylabel('$Y/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
axis equal
axis([-0.75 1.2 -1.5 0.2])
set(handaxes3, 'Box','off')



%Figure 8 c)



f5=figure
handaxes1 = axes('Position', [0.12 0.12 0.8 0.8]);


plot3((PosXSq92(1,1:TrajLSq92)-PosXSq92(1,1))/S_A,(PosYSq92(1,1:TrajLSq92)-PosYSq92(1,1))/S_A,(PosZSq92(1,1:TrajLSq92)-PosZSq92(1,1))/S_A,'b:','LineWidth',2)
view(-40,50)
hold on;
set(gca,'XTick',[-0.9 -0.4 0.2]);
set(gca, 'FontSize', Fnt)
set(gca,'XTickLabel',str2mat('-1  ', '-0.5', '  0'))
set(gca,'YTick',[-0.4 0 0.4 0.8]);
set(gca,'YTickLabel',str2mat('-0.4','  0', '  0.4', '   0.8'))
xlabel('$X/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
ylabel('$Y/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
zlabel('$Z/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
axis equal
axis([-1 0.2 -0.4 0.8])

%Obtain the points of zero Acceleration
[pks,locsr] = findpeaks(VelZSq92(1,1:TrajLSq92-1));
[pks,locsk] = findpeaks(-VelZSq92(1,1:TrajLSq92-1));

%Clean the points to interesting intervals
if locsr(1)>locsk(1)
    locsk=locsk(2:end);
else
end

if locsr(end)>locsk(end)
    locsr=locsr(1:end-1);
else
end

fip=0;
LK=[];
LR=[];
for fi=1:length(locsk)
    if  locsk(fi)-locsr(fi)>5 && locsk(fi)>0 && locsr(fi)>0
        fip=fip+1;
        LK(fip)=locsk(fi);
        LR(fip)=locsr(fi);
    else
    end
end

for fi=1:length(LK)
    
    plot3((PosXSq92(1,LK(fi))-PosXSq92(1,1))/S_A,(PosYSq92(1,LK(fi))-PosYSq92(1,1))/S_A,(PosZSq92(1,LK(fi))-PosZSq92(1,1))/S_A, 'ko','MarkerFaceColor','k')
    hold on
    plot3((PosXSq92(1,LR(fi))-PosXSq92(1,1))/S_A,(PosYSq92(1,LR(fi))-PosYSq92(1,1))/S_A,(PosZSq92(1,LR(fi))-PosZSq92(1,1))/S_A,'ko','MarkerFaceColor',[1 1 1])
end

hold off
handaxes3 = axes('Position', [0.7 0.4 0.2 0.2]);
plot((PosXSq92(1,1:TrajLSq92)-PosXSq92(1,1))/S_A,(PosYSq92(1,1:TrajLSq92)-PosYSq92(1,1))/S_A,'b:','LineWidth',2)
set(gca,'XTick',[-0.9 -0.4 0.2]);
set(gca, 'FontSize', Fnt)
set(gca,'XTickLabel',str2mat('-1  ', '-0.5', '  0'))
set(gca,'YTick',[-0.4 0 0.4 0.8]);
set(gca,'YTickLabel',str2mat('-0.4','  0', '  0.4', '   0.8'))
xlabel('$X/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
ylabel('$Y/\sqrt{A_p}$','Interpreter','LaTex','FontSize',Fnt)
axis equal
axis([-0.9 0.2 -0.4 0.8])
set(handaxes3, 'Box','off')
